package Boundary;

# ABSTRACT: map boundary

# $Id: Boundary.pm 547 2012-04-17 10:16:25Z xliosha@gmail.com $


use 5.010;
use strict;
use warnings;

use autodie;
use Carp;

use Math::Polygon;
use Math::Polygon::Tree;
use Math::Geometry::Planar::GPC::Polygon 'new_gpc';




=method new

    my $bound = Boundary->new( \@points );
    my $bound = Boundary->new( $poly_file_name );

Constructor

=cut

sub new {
    my ($class, $boundary) = @_;
    
    if ( !ref $boundary ) {
        my @bound;
        open my $pf, '<', $boundary;
        while ( my $line = readline $pf ) {
            if ( $line =~ /^\d/x ) {
                @bound = ();
            }
            elsif ( $line =~ /^\s+ ([0-9.E+-]+) \s+ ([0-9.E+-]+) /xms ) {
                push @bound, [ $1+0, $2+0 ];
            }
            elsif ( $line =~ /^END/x ) {
                # !!! first ring only!
                @bound = reverse @bound  if Math::Polygon->new( @bound )->isClockwise();
                last;
            }
        }
        close $pf;
        $boundary = \@bound;
    }

    my $gpc = new_gpc();
    $gpc->add_polygon( $boundary, 0 );

    my $self = {
        chain => $boundary,
        tree  => Math::Polygon::Tree->new($boundary),
        gpc   => $gpc,
    };  

    return bless $self, $class;
}



=method get_points

    my $chain = $bound->get_points();

=cut

sub get_points {
    my ($self) = @_;
    return $self->{chain};
}


=method contains

    if ( $bound->contains([$x, $y]) )  { ... }

=cut

sub contains {
    my ($self, $point) = @_;
    return $self->{tree}->contains( $point );
}



1;

